<?php
/*
Plugin Name: DF Accessible Colors
Plugin URI:  https://www.dentalfone.com/
Description: Adjust sitewide color contrast for accessibility.
Version:     1.0
Author:      Dentalfone
Author URI:  https://www.dentalfone.com/
Text Domain: DF Accessible Colors
*/

add_shortcode( 'accessible_colors', 'acolor');
function acolor( $attr, $accontent ) {
  $acolor_string .= '<i class="fa fa-wheelchair" aria-hidden="true"></i>Accessible Colors<br><br><button class="dfg-contrast">Adjust Color Contrast</button>&nbsp;<button class="dfg-reset">Reset Color</button>';
  $acolor_string .= do_shortcode($accontent);
  return $acolor_string;
}

function acolor_styles() {
    wp_enqueue_style( 'acolor-css', plugins_url( 'color-style.css', __FILE__) );
}
add_action( 'wp_enqueue_scripts', 'acolor_styles');

function acolor_scripts() {
    wp_enqueue_script( 'acolor-js', plugins_url( 'color-script.js', __FILE__) );
}
add_action( 'wp_enqueue_scripts', 'acolor_scripts');

?>